VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3975
   ClientLeft      =   2550
   ClientTop       =   2040
   ClientWidth     =   5160
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3975
   ScaleWidth      =   5160
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   4080
      TabIndex        =   8
      Top             =   3120
      Width           =   735
   End
   Begin VB.ComboBox DeviceNum 
      Height          =   315
      Left            =   2640
      TabIndex        =   6
      Text            =   "Combo1"
      Top             =   720
      Width           =   1095
   End
   Begin VB.CommandButton cmdReadDI 
      Caption         =   "Read DI Chan 0"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   4
      Top             =   1920
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXSR SRDI 
      Left            =   4320
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Sample AI Chan 0"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1320
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   720
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   4320
      Top             =   1440
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SRAI 
      Left            =   4320
      Top             =   840
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label6 
      Caption         =   "Digital Inputs of Chan 0 have pullups so will be logic 1 (green) if floating.  Pull them to GND to see change of state."
      Height          =   615
      Left            =   480
      TabIndex        =   12
      Top             =   3000
      Width           =   3015
   End
   Begin VB.Label Label5 
      Caption         =   "bit5"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   5.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2520
      TabIndex        =   11
      Top             =   2640
      Width           =   255
   End
   Begin VB.Shape DigitalBit 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   5
      Left            =   2520
      Shape           =   3  'Circle
      Top             =   2400
      Width           =   135
   End
   Begin VB.Shape DigitalBit 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   4
      Left            =   2880
      Shape           =   3  'Circle
      Top             =   2400
      Width           =   135
   End
   Begin VB.Shape DigitalBit 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   3
      Left            =   3240
      Shape           =   3  'Circle
      Top             =   2400
      Width           =   135
   End
   Begin VB.Label Label4 
      Caption         =   "bit2"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   5.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3600
      TabIndex        =   10
      Top             =   2640
      Width           =   255
   End
   Begin VB.Label Label3 
      Caption         =   "bit0"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   5.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   4320
      TabIndex        =   9
      Top             =   2640
      Width           =   255
   End
   Begin VB.Shape DigitalBit 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   2
      Left            =   3600
      Shape           =   3  'Circle
      Top             =   2400
      Width           =   135
   End
   Begin VB.Shape DigitalBit 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   1
      Left            =   3960
      Shape           =   3  'Circle
      Top             =   2400
      Width           =   135
   End
   Begin VB.Shape DigitalBit 
      FillColor       =   &H0000FF00&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   0
      Left            =   4320
      Shape           =   3  'Circle
      Top             =   2400
      Width           =   135
   End
   Begin VB.Label Label2 
      Caption         =   "DriverLINX Device Number"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2640
      TabIndex        =   7
      Top             =   480
      Width           =   1455
   End
   Begin VB.Label lblDIResult 
      BackColor       =   &H8000000E&
      Height          =   375
      Left            =   2640
      TabIndex        =   5
      Top             =   1920
      Width           =   1095
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   3
      Top             =   120
      Width           =   1455
   End
   Begin VB.Label lblResult 
      BackColor       =   &H8000000E&
      Height          =   375
      Left            =   2640
      TabIndex        =   2
      Top             =   1320
      Width           =   1095
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdExit_Click()

' unload the driver for each object on exit
SRAI.Req_DLL_name = ""
SRDI.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
' read in the device number we should use
Dim devNum As Integer
devNum = CInt(DeviceNum.Text)
' open the driver and initialize the hardware
With SRAI
.Req_DLL_name = "kpci3108"  ' give driver name to avoid OpenDriverLINX dialog; use kmb1700 for DAS-1700 driver
.Req_device = devNum
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With

' use of the LDD control is not required
If SRAI.Res_result = DL_NoErr Then
cmdSample.Enabled = True
LDD.Req_DLL_name = SRAI.Req_DLL_name
LDD.device = SRAI.Req_device
LDD.Refresh   ' load the LDD with info for the device number/driver in use
Form1.Caption = "Using the AI and DI of " & LDD.Dev_Model  ' display the Model number of the board
Else
' error check
SRAI.Req_op = DL_MESSAGEBOX
SRAI.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware

' open driver and init hardware for second control
' by specifying a different device number and/or driver name
' this second control could be used with a second board from either same
' driver family or with second board from another driver family
With SRDI
.Req_DLL_name = "kpci3108"
.Req_device = devNum
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh

End With
If SRDI.Res_result = DL_NoErr Then
cmdReadDI.Enabled = True
Else
' error check
SRDI.Req_op = DL_MESSAGEBOX
SRDI.Refresh
End If
Form1.SetFocus  'set focus back to our form
End Sub

Private Sub cmdReadDI_Click()
SetupDISingleValue
SRDI.Refresh
' if no errors then
If SRDI.Res_result = DL_NoErr Then
lblDIResult.Caption = SRDI.Res_Sta_ioValue
' .Res_Sta_ioValue property can host single value readings
'
' all the bits associated with the digital channel will be in this reading
'
' for KPCI-3108 Series DI chan 0, there are 6 bits, so value can range from 0 to 63.
' Do a logical AND with 2^i to determine the state of the ith bit
Dim i As Integer
For i = 0 To 5
If (SRDI.Res_Sta_ioValue And 2 ^ i) = 2 ^ i Then
DigitalBit(i).FillColor = vbGreen
Else
DigitalBit(i).FillColor = vbRed
End If
Next i
Else
'error check
SRDI.Req_op = DL_MESSAGEBOX
SRDI.Refresh
End If

End Sub

Private Sub cmdSample_Click()
SetupAISingleValue
SRAI.Refresh  ' do it

' if no errors, then
If SRAI.Res_result = DL_NoErr Then
lblResult.Caption = Format(SRAI.DLCode2Volts(SRAI.Res_Sta_ioValue), "#0.##0")
' .Res_Sta_ioValue property contains the single value result
' but it is in units of the A/D converter, e.g., counts
'
' DLCode2Volts method converts counts to volts, but this method always
' assumes a bipolar gain of 1 was used
' for data at other gains, use VBArrayBufferConvert method or factor in
' your gain
Else
' error check
SRAI.Req_op = DL_MESSAGEBOX
SRAI.Refresh
End If
End Sub

Private Sub Form_Load()
' populate the combo box with legal DriverLINX device numbers 0..5
Dim i As Integer
For i = 0 To 5
DeviceNum.AddItem Str(i), i
Next i
DeviceNum.ListIndex = 0  ' set the combo box equal to the first entry
End Sub


Sub SetupAISingleValue()
With SRAI
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_AI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel will be used
.Sel_chan_start = 0            ' is is channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
End With
End Sub
Sub SetupDISingleValue()
With SRDI
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = 0            ' is is channel 0
End With
End Sub
